/*
 * Decompiled with CFR 0.152.
 */
package Omroeper;

import Omroeper.combineClip;
import Omroeper.configFile;
import Omroeper.licentieKey;
import Omroeper.listFragmenten;
import Omroeper.listOmroeper;
import Omroeper.logFile;
import Omroeper.makePDF;
import Omroeper.msgDialog;
import Omroeper.playClip;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;

public class Main {
    public static String ProgramName = "Stationsomroeper Pro";
    public static String ProgramVersion = "1.0.1.1";
    public static String ProgramPath = System.getProperty("user.dir");
    public static String UserName = System.getProperty("user.name");
    public static String OsName = System.getProperty("os.name");
    public static String OsVersion = System.getProperty("os.version");
    public static String Architecture = System.getProperty("os.architecture");
    public static String JavaJRE = System.getProperty("java.version");
    public static String JavaPath = System.getProperty("java.home");
    public static String Separator = System.getProperty("file.separator");
    public static Date dateNow = new Date();
    public static SimpleDateFormat stf1 = new SimpleDateFormat("dd-MM-yyyy");
    public static SimpleDateFormat dtf1 = new SimpleDateFormat("dd MMMM yyyy");
    public static SimpleDateFormat dtf2 = new SimpleDateFormat("dd-MM-yyyy");
    public static SimpleDateFormat dtf3 = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat dtf4 = new SimpleDateFormat("HH:mm");
    public static SimpleDateFormat dtf5 = new SimpleDateFormat("yyyy");
    public static JFrame frame = new JFrame();
    public static File file = new File("");
    public static File dir = new File("");
    public static Color myColor = new Color(255, 255, 255);
    public static Font myFont = new Font("SansSerif", 0, 12);
    public static String[] licentie = new String[]{"", "", "", ""};
    public static String[] config = new String[]{"true", "true", "", "", "false", "false", ProgramPath + Separator + "Sounds" + Separator, ProgramPath + Separator + "Male" + Separator, ProgramPath + Separator + "Female" + Separator, "Male", "true"};
    public static ArrayList<String> stationsBericht = new ArrayList();
    public static String Text;
    public static String labelText;
    public static String areaText;
    public static boolean msgAnser;
    public static boolean list1;
    public static boolean list2;
    public static boolean showTime;
    public static int fragmentSave;
    public static JList<String> List_Fragmenten;
    public static JList<String> List_Omroeper1;
    public static JList<String> List_Omroeper2;
    public static JList<String> List_Omroeper3;
    public static JButton Button_Play;
    public static JButton Button_New;
    public static JButton Button_Save;
    public static JButton Button_Terug;
    public static JButton Button_Reset;
    public static JButton Button_Stop;
    public static JButton Button_Playnew;
    public static JMenuItem MenuItem_LicentieSleutel;
    public static JCheckBoxMenuItem MenuCheckItem_Programma_Tune;
    public static JCheckBoxMenuItem MenuCheckItem_DingDongDang;
    public static JRadioButtonMenuItem MenuRadioItem_Male;
    public static JRadioButtonMenuItem MenuRadioItem_Female;
    public static JTextArea textArea;
    public static JLabel Label_ProgrammaInfo;
    public static JLabel Label_Stem;
    public static JLabel Label_UwGeluidsfragmenten;
    public static JLabel Label_Fragmenten;
    public static JLabel Label_Binnenlands;
    public static JLabel Label_Buitenlands;

    static {
        msgAnser = false;
        list1 = true;
        list2 = false;
        showTime = true;
        fragmentSave = 1;
        List_Fragmenten = new JList();
        List_Omroeper1 = new JList();
        List_Omroeper2 = new JList();
        List_Omroeper3 = new JList();
        Button_Play = new JButton("Afspelen");
        Button_New = new JButton("Nieuw");
        Button_Save = new JButton("Opslaan");
        Button_Terug = new JButton("Stap terug");
        Button_Reset = new JButton("Reset");
        Button_Stop = new JButton("Stop");
        Button_Playnew = new JButton("Afspelen");
        MenuItem_LicentieSleutel = new JMenuItem("Licentie Sleutel");
        MenuCheckItem_Programma_Tune = new JCheckBoxMenuItem("Programma Tune");
        MenuCheckItem_DingDongDang = new JCheckBoxMenuItem("Inclusief DingDongDang");
        MenuRadioItem_Male = new JRadioButtonMenuItem("Mannelijke Stem");
        MenuRadioItem_Female = new JRadioButtonMenuItem("Vrouwelijke Stem");
        textArea = new JTextArea();
        Label_ProgrammaInfo = new JLabel("Programma Info.");
        Label_Stem = new JLabel("Mannelijke Stem");
        Label_UwGeluidsfragmenten = new JLabel("Map met uw geluidsfragmenten");
        Label_Fragmenten = new JLabel("Fragmenten");
        Label_Binnenlands = new JLabel("Binnenlandse plaatsnamen");
        Label_Buitenlands = new JLabel("Buitenlandse plaatsnamen");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main window = new Main();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Main() throws IOException {
        File file;
        this.initialize();
        frame.setVisible(true);
        Main.file = new File("Config.csv");
        if (Main.file.exists()) {
            new configFile(2);
        } else {
            new configFile(1);
            new configFile(2);
        }
        if (Boolean.parseBoolean(config[0])) {
            Main.config[2] = dtf1.format(dateNow);
            Calendar c = Calendar.getInstance();
            c.add(5, 31);
            Main.config[3] = dtf3.format(c.getTime());
            Main.config[0] = "false";
            new configFile(1);
        }
        new licentieKey();
        Main.file = new File("Omroepper.log");
        if (Main.file.exists()) {
            Main.file.delete();
        }
        new logFile(0, "");
        dir = new File("Male");
        if (dir.exists()) {
            new logFile(1, "Mannelijke geluidsfragmenten gevonden.");
        } else {
            new logFile(1, "Mannelijke geluidsfragmenten niet gevonden.");
        }
        dir = new File("Female");
        if (dir.exists()) {
            new logFile(1, "Vrouwelijke geluidsfragmenten gevonden.");
        } else {
            new logFile(1, "Vrouwelijke geluidsfragmenten niet gevonden.");
        }
        dir = new File(config[6]);
        if (dir.exists()) {
            new logFile(1, "Map met geluidsfragmenten gevonden.");
        } else {
            new logFile(1, "Map net geluidsfragmenten niet gevonden.");
        }
        new listFragmenten();
        new listOmroeper();
        if (Boolean.parseBoolean(config[4])) {
            Label_ProgrammaInfo.setText("Gebruikers licentie verleend aan: " + config[5]);
        } else {
            int i = (int)ChronoUnit.DAYS.between(LocalDate.now(), LocalDate.parse(config[3]));
            Label_ProgrammaInfo.setText("Uw gebruikers licentie loopt af over " + i + " dagen.");
            if (i <= 1) {
                Label_ProgrammaInfo.setText("Uw gebruikers licentie van 31 dagen zijn voorbij.");
                List_Fragmenten.setEnabled(false);
                List_Omroeper1.setEnabled(false);
                List_Omroeper2.setEnabled(false);
                List_Omroeper3.setEnabled(false);
                Button_Play.setEnabled(false);
                Button_New.setEnabled(false);
                Button_Save.setEnabled(false);
                Button_Playnew.setEnabled(false);
                Button_Terug.setEnabled(false);
                Button_Reset.setEnabled(false);
                Button_Stop.setEnabled(false);
            }
        }
        if (Boolean.parseBoolean(config[1])) {
            Main.file = new File("Sounds" + Separator + "dingdongdang.wav");
            if (Main.file.exists()) {
                new playClip(Main.file, false);
            } else {
                new logFile(1, "Geluids bestand \"dingdongdang.wav\" niet gevonden.");
            }
        }
        int i = 1;
        while (i <= 25) {
            file = new File("wavAppended" + i + ".wav");
            if (file.exists()) {
                file.delete();
            }
            ++i;
        }
        i = 1;
        while (i <= 25) {
            file = new File("Geluidsfragment_" + i + ".wav");
            if (file.exists()) {
                file.delete();
            }
            ++i;
        }
        Label_UwGeluidsfragmenten.setText(List_Fragmenten.getModel().getSize() + " - Geluidsfragmenten");
        Label_Fragmenten.setText(List_Omroeper1.getModel().getSize() + " - Fragmenten");
        Label_Binnenlands.setText(List_Omroeper2.getModel().getSize() + " - Binnenlandse plaatsnamen");
        Label_Buitenlands.setText(List_Omroeper3.getModel().getSize() + " - Buitenlandse plaatsnamen");
    }

    private void initialize() {
        frame.setResizable(false);
        frame.setFont(myFont);
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/Omroeper/images/Icon.png")));
        frame.setBounds(100, 100, 930, 625);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setTitle(ProgramName + " - versie " + ProgramVersion);
        frame.getContentPane().setLayout(null);
        JScrollPane scrollPane_0 = new JScrollPane();
        scrollPane_0.setBounds(10, 39, 250, 450);
        frame.getContentPane().add(scrollPane_0);
        scrollPane_0.setViewportView(List_Fragmenten);
        List_Fragmenten.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (list1) {
                    showTime = true;
                    file = new File(config[6] + Separator + List_Fragmenten.getSelectedValue() + ".wav");
                    if (file.exists()) {
                        new playClip(file, showTime);
                    } else {
                        new logFile(1, "Geluidsfragment " + String.valueOf(file) + " niet gevonden.");
                    }
                }
            }
        });
        List_Fragmenten.setToolTipText("Kies een Geluidsfragment en klik");
        List_Fragmenten.setBorder(new BevelBorder(1, null, null, null, null));
        List_Fragmenten.setFont(myFont);
        List_Fragmenten.setBackground(myColor);
        Button_Play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list1) {
                    showTime = true;
                    labelText = Label_ProgrammaInfo.getText();
                    file = new File(config[6] + Separator + List_Fragmenten.getSelectedValue() + ".wav");
                    if (file.exists()) {
                        new playClip(file, showTime);
                    } else {
                        new logFile(1, "Geluidsfragment " + String.valueOf(file) + " niet gevonden.");
                    }
                }
            }
        });
        Button_Play.setToolTipText("Kies een Geluidsfragment en klik");
        Button_Play.setMargin(new Insets(0, 0, 0, 0));
        Button_Play.setFont(myFont);
        Button_Play.setFocusable(false);
        Button_Play.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Play.setBounds(10, 495, 80, 23);
        frame.getContentPane().add(Button_Play);
        JButton Button_Open = new JButton("Open Map");
        Button_Open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new msgDialog(3, "Verkenner", "De map wordt in de Verkenner geopend, \nhet programma wordt daarna afgesloten.\nWilt u doorgaan. ");
                if (msgAnser) {
                    File file = new File(config[6]);
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.open(file);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        });
        Button_Open.setToolTipText("Open de Map in Verkenner");
        Button_Open.setMargin(new Insets(0, 0, 0, 0));
        Button_Open.setFont(new Font("SansSerif", 0, 12));
        Button_Open.setFocusable(false);
        Button_Open.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Open.setBounds(96, 495, 80, 23);
        frame.getContentPane().add(Button_Open);
        Button_New.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list1) {
                    areaText = "";
                    new logFile(1, "Maak een nieuw stationsomroep bericht.");
                    Label_ProgrammaInfo.setText("Maak een nieuw stationsomroep bericht.");
                    List_Fragmenten.setSelectedIndex(0);
                    List_Fragmenten.setEnabled(false);
                    List_Omroeper1.setEnabled(true);
                    List_Omroeper2.setEnabled(true);
                    List_Omroeper3.setEnabled(true);
                    list1 = false;
                    list2 = true;
                    Button_Play.setEnabled(false);
                    Button_New.setEnabled(false);
                    Button_Save.setEnabled(true);
                    Button_Playnew.setEnabled(true);
                    Button_Terug.setEnabled(true);
                    Button_Reset.setEnabled(true);
                    Button_Stop.setEnabled(true);
                    stationsBericht.removeAll(stationsBericht);
                    int i = 1;
                    while (i <= 25) {
                        File file = new File("wavAppended" + i + ".wav");
                        if (file.exists()) {
                            file.delete();
                        }
                        ++i;
                    }
                    File file = new File("Geluidsfragment.wav");
                    if (file.exists()) {
                        file.delete();
                    }
                }
            }
        });
        Button_New.setToolTipText("Cre\u00eber een nieuw Geluidsfragment");
        Button_New.setMargin(new Insets(0, 0, 0, 0));
        Button_New.setFont(myFont);
        Button_New.setFocusable(false);
        Button_New.setBorder(new BevelBorder(0, null, null, null, null));
        Button_New.setBounds(180, 495, 80, 23);
        frame.getContentPane().add(Button_New);
        JSeparator separator_1 = new JSeparator();
        separator_1.setBounds(10, 529, 890, 2);
        frame.getContentPane().add(separator_1);
        Label_ProgrammaInfo.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/Label_ProgramInfo.png")));
        Label_ProgrammaInfo.setFont(myFont);
        Label_ProgrammaInfo.setBounds(10, 538, 388, 14);
        Label_ProgrammaInfo.setForeground(new Color(0, 0, 255));
        frame.getContentPane().add(Label_ProgrammaInfo);
        JLabel Label_Datum = new JLabel("Datum");
        Label_Datum.setHorizontalAlignment(2);
        Label_Datum.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/Label_Datum.png")));
        Label_Datum.setForeground(new Color(0, 0, 255));
        Label_Datum.setFont(myFont);
        Label_Datum.setBounds(400, 538, 138, 14);
        Label_Datum.setText("Datum " + dtf2.format(dateNow));
        frame.getContentPane().add(Label_Datum);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(280, 39, 200, 390);
        frame.getContentPane().add(scrollPane_1);
        scrollPane_1.setViewportView(List_Omroeper1);
        List_Omroeper1.setEnabled(false);
        List_Omroeper1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (list2) {
                    areaText = textArea.getText();
                    file = config[9].contains("Male") ? new File(config[7] + Separator + "Fragmenten" + Separator + List_Omroeper1.getSelectedValue() + ".wav") : new File(config[8] + Separator + "Fragmenten" + Separator + List_Omroeper1.getSelectedValue() + ".wav");
                    showTime = true;
                    if (file.exists()) {
                        stationsBericht.add(file.toString());
                        new playClip(file, showTime);
                        textArea.setText(textArea.getText() + " " + List_Omroeper1.getSelectedValue());
                    } else {
                        new logFile(1, "Geluidsfragment " + String.valueOf(file) + " niet gevonden.");
                    }
                }
            }
        });
        List_Omroeper1.setBorder(new BevelBorder(1, null, null, null, null));
        List_Omroeper1.setToolTipText("Voeg geluidsfragment toe aan een nieuw geluidsfragment");
        List_Omroeper1.setFont(myFont);
        List_Omroeper1.setBackground(myColor);
        JSeparator separator_2 = new JSeparator();
        separator_2.setOrientation(1);
        separator_2.setBounds(270, 39, 2, 480);
        frame.getContentPane().add(separator_2);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setBounds(490, 39, 200, 390);
        frame.getContentPane().add(scrollPane_2);
        scrollPane_2.setViewportView(List_Omroeper2);
        List_Omroeper2.setToolTipText("Voeg geluidsfragment toe aan een nieuw geluidsfragment");
        List_Omroeper2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (list2) {
                    areaText = textArea.getText();
                    file = config[9].contains("Male") ? new File(config[7] + Separator + "Binnenlands" + Separator + List_Omroeper2.getSelectedValue() + ".wav") : new File(config[8] + Separator + "Binnenlands" + Separator + List_Omroeper2.getSelectedValue() + ".wav");
                    showTime = true;
                    if (file.exists()) {
                        stationsBericht.add(file.toString());
                        new playClip(file, showTime);
                        textArea.setText(textArea.getText() + " " + List_Omroeper2.getSelectedValue());
                    } else {
                        new logFile(1, "Geluidsfragment " + String.valueOf(file) + " niet gevonden.");
                    }
                }
            }
        });
        List_Omroeper2.setEnabled(false);
        List_Omroeper2.setBorder(new BevelBorder(1, null, null, null, null));
        List_Omroeper2.setFont(myFont);
        List_Omroeper2.setBackground(myColor);
        JScrollPane scrollPane_3 = new JScrollPane();
        scrollPane_3.setBounds(700, 39, 200, 390);
        frame.getContentPane().add(scrollPane_3);
        scrollPane_3.setViewportView(List_Omroeper3);
        List_Omroeper3.setToolTipText("Voeg geluidsfragment toe aan een nieuw geluidsfragment");
        List_Omroeper3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (list2) {
                    areaText = textArea.getText();
                    file = config[9].contains("Male") ? new File(config[7] + Separator + "Buitenlands" + Separator + List_Omroeper3.getSelectedValue() + ".wav") : new File(config[8] + Separator + "Buitenlands" + Separator + List_Omroeper3.getSelectedValue() + ".wav");
                    showTime = true;
                    if (file.exists()) {
                        stationsBericht.add(file.toString());
                        new playClip(file, showTime);
                        textArea.setText(textArea.getText() + " " + List_Omroeper3.getSelectedValue());
                    } else {
                        new logFile(1, "Geluidsfragment " + String.valueOf(file) + " niet gevonden.");
                    }
                }
            }
        });
        List_Omroeper3.setEnabled(false);
        List_Omroeper3.setBorder(new BevelBorder(1, null, null, null, null));
        List_Omroeper3.setFont(myFont);
        List_Omroeper3.setBackground(myColor);
        Label_UwGeluidsfragmenten.setHorizontalAlignment(0);
        Label_UwGeluidsfragmenten.setBounds(10, 11, 250, 20);
        Label_UwGeluidsfragmenten.setFont(myFont);
        frame.getContentPane().add(Label_UwGeluidsfragmenten);
        Label_Fragmenten.setHorizontalAlignment(0);
        Label_Fragmenten.setFont(myFont);
        Label_Fragmenten.setBounds(280, 11, 200, 20);
        frame.getContentPane().add(Label_Fragmenten);
        Label_Binnenlands.setHorizontalAlignment(0);
        Label_Binnenlands.setFont(new Font("SansSerif", 0, 12));
        Label_Binnenlands.setBounds(490, 11, 200, 20);
        frame.getContentPane().add(Label_Binnenlands);
        Label_Buitenlands.setHorizontalAlignment(0);
        Label_Buitenlands.setFont(myFont);
        Label_Buitenlands.setBounds(700, 11, 200, 20);
        frame.getContentPane().add(Label_Buitenlands);
        textArea.setEditable(false);
        textArea.setBorder(new BevelBorder(1, null, null, null, null));
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setBounds(280, 438, 620, 40);
        textArea.setFont(myFont);
        textArea.setForeground(new Color(0, 0, 255));
        frame.getContentPane().add(textArea);
        Button_Save.setEnabled(false);
        Button_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list2 && stationsBericht.size() >= 1) {
                    new logFile(1, "Geluidsfragment opslaan.");
                    new combineClip();
                }
            }
        });
        Button_Save.setToolTipText("Dit geluidsfragment opslaan");
        Button_Save.setMargin(new Insets(0, 0, 0, 0));
        Button_Save.setFont(new Font("SansSerif", 0, 12));
        Button_Save.setFocusable(false);
        Button_Save.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Save.setBounds(371, 495, 80, 23);
        frame.getContentPane().add(Button_Save);
        Button_Terug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list2 && stationsBericht.size() >= 1) {
                    stationsBericht.remove(stationsBericht.size() - 1);
                    textArea.setText(areaText);
                }
            }
        });
        Button_Terug.setToolTipText("Ga \u00e9\u00e9n stap terug");
        Button_Terug.setMargin(new Insets(0, 0, 0, 0));
        Button_Terug.setFont(new Font("SansSerif", 0, 12));
        Button_Terug.setFocusable(false);
        Button_Terug.setEnabled(false);
        Button_Terug.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Terug.setBounds(538, 495, 80, 23);
        frame.getContentPane().add(Button_Terug);
        Button_Reset.setEnabled(false);
        Button_Reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list2) {
                    List_Omroeper1.setSelectedIndex(0);
                    List_Omroeper2.setSelectedIndex(0);
                    List_Omroeper3.setSelectedIndex(0);
                    stationsBericht.removeAll(stationsBericht);
                    textArea.setText("");
                    int i = 1;
                    while (i <= 25) {
                        File file = new File("wavAppended" + i + ".wav");
                        if (file.exists()) {
                            file.delete();
                        }
                        ++i;
                    }
                    File file = new File("Geluidsfragment.wav");
                    if (file.exists()) {
                        file.delete();
                    }
                }
            }
        });
        Button_Reset.setToolTipText("Dit geluidsfragment wissen");
        Button_Reset.setMargin(new Insets(0, 0, 0, 0));
        Button_Reset.setFont(new Font("SansSerif", 0, 12));
        Button_Reset.setFocusable(false);
        Button_Reset.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Reset.setBounds(621, 495, 80, 23);
        frame.getContentPane().add(Button_Reset);
        Button_Stop.setEnabled(false);
        Button_Stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list2) {
                    stationsBericht.removeAll(stationsBericht);
                    List_Fragmenten.setEnabled(true);
                    List_Omroeper1.setSelectedIndex(0);
                    List_Omroeper2.setSelectedIndex(0);
                    List_Omroeper3.setSelectedIndex(0);
                    List_Omroeper1.setEnabled(false);
                    List_Omroeper2.setEnabled(false);
                    List_Omroeper3.setEnabled(false);
                    list1 = true;
                    list2 = false;
                    textArea.setText("");
                    Button_Play.setEnabled(true);
                    Button_New.setEnabled(true);
                    Button_Save.setEnabled(false);
                    Button_Playnew.setEnabled(false);
                    Button_Terug.setEnabled(false);
                    Button_Reset.setEnabled(false);
                    Button_Stop.setEnabled(false);
                    Label_ProgrammaInfo.setText("Kies een stations omroepbericht.");
                    int i = 1;
                    while (i <= 25) {
                        File file = new File("wavAppended" + i + ".wav");
                        if (file.exists()) {
                            file.delete();
                        }
                        ++i;
                    }
                    File file = new File("Geluidsfragment.wav");
                    if (file.exists()) {
                        file.delete();
                    }
                }
            }
        });
        Button_Stop.setToolTipText("Stoppen met het cre\u00ebren van dit geluidsfragment");
        Button_Stop.setMargin(new Insets(0, 0, 0, 0));
        Button_Stop.setFont(new Font("SansSerif", 0, 12));
        Button_Stop.setFocusable(false);
        Button_Stop.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Stop.setBounds(706, 495, 80, 23);
        frame.getContentPane().add(Button_Stop);
        Button_Playnew.setEnabled(false);
        Button_Playnew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (list2) {
                    showTime = false;
                    if (Boolean.parseBoolean(config[10])) {
                        file = new File("Sounds" + Separator + "dingdongdang.wav");
                        new playClip(file, showTime);
                    }
                    if (stationsBericht.size() >= 1) {
                        int i = 0;
                        while (i < stationsBericht.size()) {
                            file = new File(stationsBericht.get(i));
                            new playClip(file, showTime);
                            ++i;
                        }
                    }
                    Label_ProgrammaInfo.setText("Kies volgende geluidsfragment, of klik op opslaan.");
                }
            }
        });
        Button_Playnew.setToolTipText("Dit geluidsfragment afspelen");
        Button_Playnew.setMargin(new Insets(0, 0, 0, 0));
        Button_Playnew.setFont(new Font("SansSerif", 0, 12));
        Button_Playnew.setFocusable(false);
        Button_Playnew.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Playnew.setBounds(454, 495, 80, 23);
        frame.getContentPane().add(Button_Playnew);
        Label_Stem.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Male.png")));
        Label_Stem.setHorizontalAlignment(4);
        Label_Stem.setForeground(Color.BLUE);
        Label_Stem.setFont(myFont);
        Label_Stem.setBounds(732, 538, 168, 14);
        frame.getContentPane().add(Label_Stem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setFont(myFont);
        frame.setJMenuBar(menuBar);
        JMenu Menu_Programma = new JMenu("Programma");
        Menu_Programma.setFont(myFont);
        menuBar.add(Menu_Programma);
        JMenuItem MenuItem_Programma_Info = new JMenuItem("Programma Info");
        MenuItem_Programma_Info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Text = "Datum: " + dtf1.format(dateNow) + " Tijd: " + dtf4.format(dateNow) + " uur\n\nProgramma naam: " + ProgramName + "\nProgramma versie: " + ProgramVersion + "\nProgramma rechten: UniekSoft \u00a9 " + dtf5.format(dateNow) + "\nProgramma ge\u00efnstalleerd op: " + config[2] + "\nProgramma map: " + ProgramPath + Separator + "\nGeluidsfragmenten map: " + config[6] + Separator + "\n\nOperating systeem: " + OsName + "\nJava versie: " + JavaJRE + "\nJava installatie map: " + JavaPath + Separator + "\n\n";
                if (Boolean.parseBoolean(config[4])) {
                    Text = Text + "Gebruikers licentie verleend aan: " + config[5] + "\n";
                } else {
                    int i = (int)ChronoUnit.DAYS.between(LocalDate.now(), LocalDate.parse(config[3]));
                    Text = Text + "Uw gebruikers licentie loopt af over " + i + " dagen\n";
                    if (i <= 1) {
                        Text = Text + "Uw gebruikers licentie van 30 dagen zijn voorbij\n";
                    }
                }
                new msgDialog(1, "Systeem informatie", Text);
            }
        });
        MenuItem_Programma_Info.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Info.png")));
        MenuItem_Programma_Info.setFont(myFont);
        MenuItem_Programma_Info.setBackground(myColor);
        Menu_Programma.add(MenuItem_Programma_Info);
        JMenuItem MenuItem_Geluidsfragmenten = new JMenuItem("Locatie Geluidsfragmenten");
        MenuItem_Geluidsfragmenten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new logFile(1, "Locatie Geluidsfragmenten aanpassen.");
                new msgDialog(4, "Locatie Geluidsfragmenten", "U wilt de Locatie van de Geluidsfragmenten wijzigen. ");
                if (msgAnser) {
                    new msgDialog(3, "Locatie Geluidsfragmenten", "U hebt in die nieuwe Locatie een map aangemaakt, \nen daarin de Geluidsfragmenten naar toe gekopieerd. ");
                    if (msgAnser) {
                        new msgDialog(1, "Locatie Geluidsfragmenten", "Navigeer nu naar de Locatie waarin u de Geluidsfragmenten hebt opgeslagen en klik deze aan en kies Open. ");
                        JFileChooser fileChooser = new JFileChooser();
                        fileChooser.setCurrentDirectory(new File(config[6]));
                        fileChooser.setDialogTitle("Kies nieuwe DataBase Map");
                        fileChooser.setFileSelectionMode(1);
                        fileChooser.setAcceptAllFileFilterUsed(false);
                        if (fileChooser.showOpenDialog(null) == 0) {
                            Main.config[6] = fileChooser.getSelectedFile().toString() + System.getProperty("file.separator");
                            new msgDialog(3, "Locatie Geluidsfragmenten", "De nieuwe Locatie van de Geluidsfragmenten is nu " + config[6] + " \nWilt u deze nieuwe Locatie nu opslaan.");
                            if (msgAnser) {
                                new configFile(1);
                                new listFragmenten();
                            } else {
                                return;
                            }
                        }
                        return;
                    }
                    new msgDialog(1, "Locatie Geluidsfragmenten", "Maak eerst een map aan in de nieuwe Locatie en kopieer de Geluidsfragmenten naar deze nieuwe map. \nDe Locatie van de huidige DataBase vind u hier: " + config[6] + Separator + " \nEn probeer het daarna opnieuw");
                    return;
                }
            }
        });
        MenuItem_Geluidsfragmenten.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Geluidsfragmenten.png")));
        MenuItem_Geluidsfragmenten.setFont(myFont);
        MenuItem_Geluidsfragmenten.setBackground(myColor);
        Menu_Programma.add(MenuItem_Geluidsfragmenten);
        JMenuItem MenuItem_Afsluiten = new JMenuItem("Programma Afsluiten");
        MenuItem_Afsluiten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new msgDialog(4, "Afsluiten", "U wilt TrainBase Pro afsluiten.");
                if (msgAnser) {
                    new logFile(1, "TrainBase Pro is afgesloten.");
                    System.exit(0);
                }
                new logFile(1, "TrainBase Pro is niet afgesloten.");
            }
        });
        MenuItem_Afsluiten.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Exit.png")));
        MenuItem_Afsluiten.setFont(myFont);
        MenuItem_Afsluiten.setBackground(myColor);
        Menu_Programma.add(MenuItem_Afsluiten);
        JMenu Menu_Opties = new JMenu("Opties");
        Menu_Opties.setFont(myFont);
        menuBar.add(Menu_Opties);
        MenuCheckItem_Programma_Tune.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MenuCheckItem_Programma_Tune.isSelected()) {
                    new logFile(1, "Programma tune = Aan.");
                    MenuCheckItem_Programma_Tune.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Tune_1.png")));
                    Main.config[1] = "true";
                } else {
                    new logFile(1, "Programma tune = Uit.");
                    MenuCheckItem_Programma_Tune.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Tune_2.png")));
                    Main.config[1] = "false";
                }
                new configFile(1);
            }
        });
        MenuCheckItem_Programma_Tune.setSelected(true);
        MenuCheckItem_Programma_Tune.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Tune_1.png")));
        MenuCheckItem_Programma_Tune.setFont(myFont);
        MenuCheckItem_Programma_Tune.setBackground(myColor);
        Menu_Opties.add(MenuCheckItem_Programma_Tune);
        MenuRadioItem_Male.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new logFile(1, "Mannelijk Stem = Actief.");
                MenuRadioItem_Male.setSelected(true);
                MenuRadioItem_Female.setSelected(false);
                Main.config[9] = "Male";
                new configFile(1);
                new configFile(2);
            }
        });
        MenuCheckItem_DingDongDang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MenuCheckItem_DingDongDang.isSelected()) {
                    new logFile(1, "DingDongDang tune = Aan.");
                    Main.config[10] = "true";
                } else {
                    new logFile(1, "DingDongDang tune = Uit.");
                    Main.config[10] = "false";
                }
                new configFile(1);
            }
        });
        MenuCheckItem_DingDongDang.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_DingDong.png")));
        MenuCheckItem_DingDongDang.setFont(myFont);
        MenuCheckItem_DingDongDang.setBackground(myColor);
        MenuCheckItem_DingDongDang.setSelected(true);
        Menu_Opties.add(MenuCheckItem_DingDongDang);
        MenuRadioItem_Male.setSelected(true);
        MenuRadioItem_Male.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Male.png")));
        MenuRadioItem_Male.setFont(myFont);
        MenuRadioItem_Male.setBackground(myColor);
        Menu_Opties.add(MenuRadioItem_Male);
        MenuRadioItem_Female.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new logFile(1, "Vrouwelijk Stem = Actief.");
                MenuRadioItem_Male.setSelected(false);
                MenuRadioItem_Female.setSelected(true);
                Main.config[9] = "Female";
                new configFile(1);
                new configFile(2);
            }
        });
        MenuRadioItem_Female.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Female.png")));
        MenuRadioItem_Female.setFont(myFont);
        MenuRadioItem_Female.setBackground(myColor);
        Menu_Opties.add(MenuRadioItem_Female);
        JMenu MenuItem_Afdrukken = new JMenu("Fragmenten Afdrukken");
        MenuItem_Afdrukken.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_PDF.png")));
        MenuItem_Afdrukken.setFont(myFont);
        MenuItem_Afdrukken.setBackground(myColor);
        Menu_Opties.add(MenuItem_Afdrukken);
        JMenuItem MenuItem_Stationsfragmenten = new JMenuItem("Stations Geluidsfragmenten");
        MenuItem_Stationsfragmenten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new makePDF(1);
            }
        });
        MenuItem_Stationsfragmenten.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Handleiding.png")));
        MenuItem_Stationsfragmenten.setFont(myFont);
        MenuItem_Stationsfragmenten.setBackground(myColor);
        MenuItem_Afdrukken.add(MenuItem_Stationsfragmenten);
        JMenuItem MenuItem_Fragmenten = new JMenuItem("Geluidsfragmenten");
        MenuItem_Fragmenten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new makePDF(2);
            }
        });
        MenuItem_Fragmenten.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Handleiding.png")));
        MenuItem_Fragmenten.setFont(myFont);
        MenuItem_Fragmenten.setBackground(myColor);
        MenuItem_Afdrukken.add(MenuItem_Fragmenten);
        JMenuItem MenuItem_Binnenland = new JMenuItem("Binnenlandse Plaatsnamen");
        MenuItem_Binnenland.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new makePDF(3);
            }
        });
        MenuItem_Binnenland.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Handleiding.png")));
        MenuItem_Binnenland.setFont(myFont);
        MenuItem_Binnenland.setBackground(myColor);
        MenuItem_Afdrukken.add(MenuItem_Binnenland);
        JMenuItem MenuItem_Buitenland = new JMenuItem("Buitenlandse Plaatsnamen");
        MenuItem_Buitenland.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new makePDF(4);
            }
        });
        MenuItem_Buitenland.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Handleiding.png")));
        MenuItem_Buitenland.setFont(myFont);
        MenuItem_Buitenland.setBackground(myColor);
        MenuItem_Afdrukken.add(MenuItem_Buitenland);
        JMenu Menu_Help = new JMenu("Help");
        Menu_Help.setFont(myFont);
        menuBar.add(Menu_Help);
        JMenuItem MenuItem_Handleiding = new JMenuItem("Handleiding");
        MenuItem_Handleiding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new logFile(1, "Open Stationsomroeper-Pro.pdf.");
                    Desktop.getDesktop().browse(URI.create("https://wdevaal.nl/wp-content/uploads/Stationsomroeper-Pro.pdf"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    new logFile(1, "Fout melding, Kan Stationsomroeper-Pro.pdf niet openen.");
                    System.out.println("Fout melding, Kan TrainBase-Pro.pdf niet openen: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Handleiding.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Handleiding.png")));
        MenuItem_Handleiding.setFont(myFont);
        MenuItem_Handleiding.setBackground(myColor);
        Menu_Help.add(MenuItem_Handleiding);
        JMenuItem MenuItem_Website = new JMenuItem("Website");
        MenuItem_Website.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new logFile(1, "Open Website wdevaal.nl.");
                    Desktop.getDesktop().browse(URI.create("https://wdevaal.nl"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    new logFile(1, "Fout melding, Kan Website niet openen.");
                    System.out.println("Fout melding, Kan Website niet openen: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Website.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Webserver.png")));
        MenuItem_Website.setFont(myFont);
        MenuItem_Website.setBackground(myColor);
        Menu_Help.add(MenuItem_Website);
        MenuItem_LicentieSleutel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Boolean.parseBoolean(config[4])) {
                        new msgDialog(1, "Licentie Sleutel", "U hebt een legale Licentie Sleutel ge\u00efnstalleerd.");
                    } else {
                        new logFile(1, "Licentie Key aanvragen.");
                        Desktop.getDesktop().browse(URI.create("https://wdevaal.nl/licentie/"));
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    new logFile(1, "Fout melding, Kan Website niet openen.");
                    System.out.println("Fout melding, Kan Website niet openen: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_LicentieSleutel.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Licentie_2.png")));
        MenuItem_LicentieSleutel.setBackground(myColor);
        MenuItem_LicentieSleutel.setFont(myFont);
        Menu_Help.add(MenuItem_LicentieSleutel);
        JMenuItem MenuItem_Over = new JMenuItem("Over Stationsomroeper Pro");
        MenuItem_Over.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new logFile(1, "Over Stationsomroeper Pro.");
                    Text = ProgramName + " \u00a9 versie " + ProgramVersion + "\nProgramma ge\u00efnstalleerd op: " + config[2] + "\nOperating systeem: " + OsName + "\nRechten \u00a9 UniekSoft " + dtf5.format(dateNow) + "\nAuteur Willy de Vaal\nWebsite https://wdevaal.nl\n";
                    if (Boolean.parseBoolean(config[4])) {
                        Text = Text + "\nLicentie verleend aan: " + config[5];
                    }
                    new msgDialog(1, "Over Stationsomroeper Pro", Text);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    new logFile(1, "Fout melding, Over TrainBase Pro.");
                    System.out.println("Fout melding, Over TrainBase Pro: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Over.setIcon(new ImageIcon(Main.class.getResource("/Omroeper/images/MenuItem_Over.png")));
        MenuItem_Over.setBackground(myColor);
        MenuItem_Over.setFont(myFont);
        Menu_Help.add(MenuItem_Over);
        frame.setVisible(true);
    }
}

