/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.io;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.io.ArrayRandomAccessSource;
import com.itextpdf.text.io.FileChannelRandomAccessSource;
import com.itextpdf.text.io.GetBufferedRandomAccessSource;
import com.itextpdf.text.io.GroupedRandomAccessSource;
import com.itextpdf.text.io.PagedChannelRandomAccessSource;
import com.itextpdf.text.io.RAFRandomAccessSource;
import com.itextpdf.text.io.RandomAccessSource;
import com.itextpdf.text.io.StreamUtil;
import com.itextpdf.text.io.WindowRandomAccessSource;
import com.itextpdf.text.pdf.BaseFont;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;

public final class RandomAccessSourceFactory {
    private boolean forceRead = false;
    private boolean usePlainRandomAccess = false;

    public RandomAccessSourceFactory setForceRead(boolean forceRead) {
        this.forceRead = forceRead;
        return this;
    }

    public RandomAccessSourceFactory setUsePlainRandomAccess(boolean usePlainRandomAccess) {
        this.usePlainRandomAccess = usePlainRandomAccess;
        return this;
    }

    public RandomAccessSource createSource(byte[] data) {
        return new ArrayRandomAccessSource(data);
    }

    public RandomAccessSource createSource(RandomAccessFile raf) throws IOException {
        return new RAFRandomAccessSource(raf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessSource createSource(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            RandomAccessSource randomAccessSource = this.createSource(is);
            return randomAccessSource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessSource createSource(InputStream is) throws IOException {
        try {
            RandomAccessSource randomAccessSource = this.createSource(StreamUtil.inputStreamToArray(is));
            return randomAccessSource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RandomAccessSource createBestSource(String filename) throws IOException {
        File file = new File(filename);
        if (!file.canRead()) {
            if (filename.startsWith("file:/") || filename.startsWith("http://") || filename.startsWith("https://") || filename.startsWith("jar:") || filename.startsWith("wsjar:") || filename.startsWith("wsjar:") || filename.startsWith("vfszip:")) {
                return this.createSource(new URL(filename));
            }
            return this.createByReadingToMemory(filename);
        }
        if (this.forceRead) {
            return this.createByReadingToMemory(new FileInputStream(filename));
        }
        if (this.usePlainRandomAccess) {
            return new RAFRandomAccessSource(new RandomAccessFile(file, "r"));
        }
        try {
            FileChannel channel = new FileInputStream(file).getChannel();
            if (channel.size() <= 0x4000000L) {
                return new GetBufferedRandomAccessSource(new FileChannelRandomAccessSource(channel));
            }
            return new GetBufferedRandomAccessSource(new PagedChannelRandomAccessSource(channel));
        }
        catch (IOException e) {
            if (RandomAccessSourceFactory.exceptionIsMapFailureException(e)) {
                return new RAFRandomAccessSource(new RandomAccessFile(file, "r"));
            }
            throw e;
        }
    }

    public RandomAccessSource createRanged(RandomAccessSource source, long[] ranges) throws IOException {
        RandomAccessSource[] sources = new RandomAccessSource[ranges.length / 2];
        for (int i = 0; i < ranges.length; i += 2) {
            sources[i / 2] = new WindowRandomAccessSource(source, ranges[i], ranges[i + 1]);
        }
        return new GroupedRandomAccessSource(sources);
    }

    private RandomAccessSource createByReadingToMemory(String filename) throws IOException {
        InputStream is = BaseFont.getResourceStream(filename);
        if (is == null) {
            throw new IOException(MessageLocalization.getComposedMessage("1.not.found.as.file.or.resource", filename));
        }
        return this.createByReadingToMemory(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessSource createByReadingToMemory(InputStream is) throws IOException {
        try {
            ArrayRandomAccessSource arrayRandomAccessSource = new ArrayRandomAccessSource(StreamUtil.inputStreamToArray(is));
            return arrayRandomAccessSource;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean exceptionIsMapFailureException(IOException e) {
        return e.getMessage() != null && e.getMessage().indexOf("Map failed") >= 0;
    }
}

