/*
 * Decompiled with CFR 0.152.
 */
package TrainSound;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Main {
    public static String ProgramName = "TrainSound Pro";
    public static String ProgramVersion = "1.0.0.0";
    public static String ProgramPath = System.getProperty("user.dir");
    public static String UserName = System.getProperty("user.name");
    public static String UserHome = System.getProperty("user.home");
    public static String OsName = System.getProperty("os.name");
    public static String OsVersion = System.getProperty("os.version");
    public static String Architecture = System.getProperty("os.architecture");
    public static String JavaJRE = System.getProperty("java.version");
    public static String JavaPath = System.getProperty("java.home");
    public static String Separator = System.getProperty("file.separator");
    public static Date dateNow = new Date();
    public static SimpleDateFormat stf1 = new SimpleDateFormat("dd-MM-yyyy");
    public static SimpleDateFormat dtf1 = new SimpleDateFormat("dd MMMM yyyy");
    public static SimpleDateFormat dtf2 = new SimpleDateFormat("dd-MM-yyyy");
    public static SimpleDateFormat dtf3 = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat dtf4 = new SimpleDateFormat("HH:mm");
    public static SimpleDateFormat dtf5 = new SimpleDateFormat("yyyy");
    private JFrame frame;
    public static File file;
    public static Clip clip;
    public static String playSound;
    public static int cliploop;
    public static int clipPauzen;
    public static long clipLength;
    public static float previousVolume;
    public static float currentVolume;
    public static FloatControl fc;
    public static boolean mute;
    public static ImageIcon icon;
    public static Color myColor;
    public static Font myFont;
    public static JLabel Label_ProgrammaInfo;
    public static JLabel Label_Progress;
    public static JSpinner Spinner_Pauzen;
    public static JSpinner Spinner_Herhalen;
    public static JSlider VolumeSlider;
    public static JCheckBox chckbxGeenPauzenInvoeren;
    public static JList<String> List_Fragmenten;
    public static JList<String> List_Afspeellijst;
    public static JMenuItem MenuItem_Opslaan;
    public static JMenuItem MenuItem_Licentie;
    public static JButton Button_Play;
    public static JButton Button_Stop;
    public static JButton Button_Select;
    public static JButton Button_Wissen;
    public static JButton Button_Start;
    public static JButton Button_Beeindig;
    public static JButton Button_Load;
    public static JButton Button_Save;
    public static JButton Button_Mute;
    public static JTextField TextField_Clip;
    public static JTextField TextField_Length;
    public static String[] config;
    public static String[] licentie;
    public static ArrayList<String> loadSound;
    public static ArrayList<String> playList;
    public static ArrayList<String> tempList;
    public static boolean msgAnser;

    static {
        cliploop = -1;
        clipPauzen = 5;
        previousVolume = 0.0f;
        currentVolume = 6.0f;
        mute = false;
        icon = new ImageIcon();
        myColor = new Color(255, 255, 255);
        myFont = new Font("SansSerif", 0, 12);
        Label_ProgrammaInfo = new JLabel("Programma Info.");
        Label_Progress = new JLabel("");
        Spinner_Pauzen = new JSpinner();
        Spinner_Herhalen = new JSpinner();
        VolumeSlider = new JSlider(-30, 6);
        chckbxGeenPauzenInvoeren = new JCheckBox("Geen pauzen invoeren.");
        List_Fragmenten = new JList();
        List_Afspeellijst = new JList();
        MenuItem_Opslaan = new JMenuItem("Exporteer Afspeellijst");
        MenuItem_Licentie = new JMenuItem("Licentie Sleutel");
        Button_Play = new JButton("Afspelen");
        Button_Stop = new JButton("Stop");
        Button_Select = new JButton("Select");
        Button_Wissen = new JButton("Wissen");
        Button_Start = new JButton("Start");
        Button_Beeindig = new JButton("Be\u00ebindig");
        Button_Load = new JButton("Open");
        Button_Save = new JButton("Opslaan");
        Button_Mute = new JButton("");
        TextField_Clip = new JTextField();
        TextField_Length = new JTextField();
        config = new String[]{"true", "", "", "false", "false", "null", "1", "5"};
        licentie = new String[]{"", "", "", ""};
        loadSound = new ArrayList();
        playList = new ArrayList();
        tempList = new ArrayList();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main window = new Main();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Main() {
        this.initialize();
        file = new File("Playlist.csv");
        if (file.exists()) {
            Button_Load.setEnabled(true);
        }
        if ((file = new File("Config.csv")).exists()) {
            this.configFile(2);
        } else {
            this.configFile(1);
            this.configFile(2);
        }
        try {
            Path path = Paths.get("Playlist", new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Error Create Directories : Playlist" + String.valueOf(e));
        }
        if (config[0].contains("true")) {
            Main.config[1] = dtf1.format(dateNow);
            Calendar c = Calendar.getInstance();
            c.add(5, 31);
            Main.config[2] = dtf3.format(c.getTime());
            Main.config[0] = "false";
            this.configFile(1);
        }
        this.frame.setVisible(true);
        this.Licentie();
        this.listBox();
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.setResizable(false);
        this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(Main.class.getResource("/TrainSound/Images/Icon.png")));
        this.frame.setBounds(100, 100, 900, 650);
        this.frame.setLocationRelativeTo(null);
        this.frame.setTitle(ProgramName + " - Versie " + ProgramVersion);
        this.frame.setBackground(new Color(255, 255, 255));
        this.frame.setFont(myFont);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(null);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setFont(myFont);
        menuBar.setBackground(myColor);
        this.frame.setJMenuBar(menuBar);
        JMenu Menu_Programma = new JMenu("Programma");
        Menu_Programma.setFont(myFont);
        Menu_Programma.setBackground(myColor);
        menuBar.add(Menu_Programma);
        JMenuItem MenuItem_ProgramInfo = new JMenuItem("Progamma Info");
        MenuItem_ProgramInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String Info2 = Label_ProgrammaInfo.getText();
                    String Text = "Datum: " + dtf1.format(dateNow) + " Tijd: " + dtf4.format(dateNow) + " uur\n\nProgramma naam: " + ProgramName + "\nProgramma versie: " + ProgramVersion + "\nProgramma rechten: UniekSoft \u00a9 " + dtf5.format(dateNow) + "\nProgramma ge\u00efnstalleerd op: " + config[1] + "\nProgramma map: " + ProgramPath + Separator + "\nGeluidsfragmenten map: " + config[5] + Separator + "\n\nOperating systeem: " + OsName + "\nJava versie: " + JavaJRE + "\nJava installatie map: " + JavaPath + Separator + "\n\n";
                    if (Boolean.parseBoolean(config[3])) {
                        Text = Text + "Gebruikers licentie verleend aan: " + config[4] + "\n";
                    } else {
                        int i = (int)ChronoUnit.DAYS.between(LocalDate.now(), LocalDate.parse(config[2]));
                        Text = Text + "Uw gebruikers licentie loopt af over " + i + " dagen\n";
                        if (i <= 1) {
                            Text = Text + "Uw gebruikers licentie van 30 dagen zijn voorbij\n";
                        }
                    }
                    Label_ProgrammaInfo.setText("Programma Info.");
                    Main.this.msgDialog(1, "", Text);
                    Label_ProgrammaInfo.setText(Info2);
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_ProgramInfo: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_ProgramInfo.setFont(myFont);
        MenuItem_ProgramInfo.setBackground(myColor);
        MenuItem_ProgramInfo.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Info.png")));
        Menu_Programma.add(MenuItem_ProgramInfo);
        JMenuItem MenuItem_Geluidsfragmenten = new JMenuItem("Locatie Geluidsfragmenten");
        MenuItem_Geluidsfragmenten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String Info2 = Label_ProgrammaInfo.getText();
                    Label_ProgrammaInfo.setText("Kies uw geluidsfragmenten map.");
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setCurrentDirectory(new File(config[5]));
                    fileChooser.setDialogTitle("Geluidsfragmenten Map");
                    fileChooser.setFileSelectionMode(1);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    if (fileChooser.showOpenDialog(null) == 0) {
                        Main.config[5] = fileChooser.getSelectedFile().toString() + System.getProperty("file.separator");
                        Main.this.configFile(1);
                        Main.this.configFile(2);
                        Main.this.listBox();
                    }
                    Label_ProgrammaInfo.setText(Info2);
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Geluidsfragmenten: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Geluidsfragmenten.setFont(myFont);
        MenuItem_Geluidsfragmenten.setBackground(myColor);
        MenuItem_Geluidsfragmenten.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Geluidsfragmenten.png")));
        Menu_Programma.add(MenuItem_Geluidsfragmenten);
        JMenuItem MenuItem_Openmap = new JMenuItem("Open Geluidsfragmenten Map");
        MenuItem_Openmap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = new File(config[5]);
                    Desktop desktop = Desktop.getDesktop();
                    desktop.open(file);
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Openmap: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Openmap.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Openmap.png")));
        MenuItem_Openmap.setFont(myFont);
        MenuItem_Openmap.setBackground(myColor);
        Menu_Programma.add(MenuItem_Openmap);
        JMenuItem MenuItem_Update = new JMenuItem("Update Geluidsfragmenten Map");
        MenuItem_Update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Main.this.listBox();
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Update: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Update.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Update.png")));
        MenuItem_Update.setFont(myFont);
        MenuItem_Update.setBackground(myColor);
        Menu_Programma.add(MenuItem_Update);
        JMenuItem MenuItem_Afsluiten = new JMenuItem("Programma Afsluiten");
        MenuItem_Afsluiten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String Info2 = Label_ProgrammaInfo.getText();
                    Label_ProgrammaInfo.setText("TrainSound Pro afsluiten.");
                    Main.this.msgDialog(4, "", "U wilt TrainSound Pro afsluiten.");
                    if (msgAnser) {
                        System.exit(0);
                    }
                    Label_ProgrammaInfo.setText(Info2);
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Afsluiten: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Afsluiten.setFont(myFont);
        MenuItem_Afsluiten.setBackground(myColor);
        MenuItem_Afsluiten.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Exit.png")));
        Menu_Programma.add(MenuItem_Afsluiten);
        JMenu Menu_Opties = new JMenu("Opties");
        Menu_Opties.setFont(myFont);
        Menu_Opties.setBackground(myColor);
        menuBar.add(Menu_Opties);
        JMenu Menu_DownloadGeluidsfragmenten = new JMenu("Download Geluidsfragmenten");
        Menu_DownloadGeluidsfragmenten.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Download.png")));
        Menu_DownloadGeluidsfragmenten.setFont(myFont);
        Menu_DownloadGeluidsfragmenten.setBackground(myColor);
        Menu_Opties.add(Menu_DownloadGeluidsfragmenten);
        JMenuItem MenuItem_FreeSound_1 = new JMenuItem("");
        MenuItem_FreeSound_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("https://freesound.org/browse/tags/?f=tag:%22railway%22"));
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_FreeSound: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_FreeSound_1.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Wav.png")));
        MenuItem_FreeSound_1.setFont(myFont);
        MenuItem_FreeSound_1.setBackground(myColor);
        MenuItem_FreeSound_1.setText("Download van FreeSound (Spoorweg)");
        Menu_DownloadGeluidsfragmenten.add(MenuItem_FreeSound_1);
        JMenuItem MenuItem_FreeSound_2 = new JMenuItem("");
        MenuItem_FreeSound_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("https://freesound.org/browse/tags/?f=tag:%22trains%22"));
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_FreeSound: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_FreeSound_2.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Wav.png")));
        MenuItem_FreeSound_2.setFont(myFont);
        MenuItem_FreeSound_2.setBackground(myColor);
        MenuItem_FreeSound_2.setText("Download van FreeSound (Treinen)");
        Menu_DownloadGeluidsfragmenten.add(MenuItem_FreeSound_2);
        JMenuItem MenuItem_FreeSound_3 = new JMenuItem("");
        MenuItem_FreeSound_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("https://freesound.org/browse/tags/?f=tag:%22station%22"));
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_FreeSound: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_FreeSound_3.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Wav.png")));
        MenuItem_FreeSound_3.setFont(myFont);
        MenuItem_FreeSound_3.setBackground(myColor);
        MenuItem_FreeSound_3.setText("Download van FreeSound (Station)");
        Menu_DownloadGeluidsfragmenten.add(MenuItem_FreeSound_3);
        JMenu Menu_Help = new JMenu("Help");
        Menu_Help.setFont(myFont);
        Menu_Help.setBackground(myColor);
        menuBar.add(Menu_Help);
        Menu_Opties.setFont(myFont);
        MenuItem_Opslaan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File file = new File("Playlist" + Separator + "Playlist.wav");
                    if (file.exists()) {
                        int length;
                        FileDialog fileDialog = new FileDialog((Frame)Main.this.frame, null, 1);
                        fileDialog.setDirectory(config[5]);
                        fileDialog.setFile("Playlist" + Separator + "Playlist.wav");
                        fileDialog.setVisible(true);
                        String fileName = fileDialog.getFile();
                        file = new File(fileDialog.getDirectory(), fileName);
                        FileInputStream is = null;
                        FileOutputStream os = null;
                        byte[] buffer = new byte[1024];
                        is = new FileInputStream("Playlist" + Separator + "Playlist.wav");
                        os = new FileOutputStream(file);
                        buffer = new byte[1024];
                        while ((length = ((InputStream)is).read(buffer)) > 0) {
                            ((OutputStream)os).write(buffer, 0, length);
                        }
                        ((InputStream)is).close();
                        ((OutputStream)os).close();
                    } else {
                        Main.this.msgDialog(1, "", "Het geluidsfragment bestaan (nog) niet. ");
                    }
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Opslaan: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Opslaan.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Opslaan.png")));
        MenuItem_Opslaan.setFont(myFont);
        MenuItem_Opslaan.setBackground(myColor);
        Menu_Opties.add(MenuItem_Opslaan);
        JMenuItem MenuItem_Handleiding = new JMenuItem("Handleiding");
        MenuItem_Handleiding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("https://wdevaal.nl/wp-content/uploads/TrainSound-Pro.pdf"));
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Handleiding: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Handleiding.setFont(myFont);
        MenuItem_Handleiding.setBackground(myColor);
        MenuItem_Handleiding.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Handleiding.png")));
        Menu_Help.add(MenuItem_Handleiding);
        JMenuItem MenuItem_Website = new JMenuItem("Website");
        MenuItem_Website.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create("https://wdevaal.nl"));
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Handleiding: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Website.setFont(myFont);
        MenuItem_Website.setBackground(myColor);
        MenuItem_Website.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Webserver.png")));
        Menu_Help.add(MenuItem_Website);
        MenuItem_Licentie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String Info = Label_ProgrammaInfo.getText();
                    if (Boolean.parseBoolean(config[3])) {
                        Label_ProgrammaInfo.setText("Check Licentie Sleutel.");
                        Main.this.msgDialog(1, "", "U hebt een legale Licentie Sleutel ge\u00efnstalleerd.");
                    } else {
                        Desktop.getDesktop().browse(URI.create("https://wdevaal.nl/licentie/"));
                    }
                    Label_ProgrammaInfo.setText(Info);
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Licentie: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Licentie.setFont(myFont);
        MenuItem_Licentie.setBackground(myColor);
        MenuItem_Licentie.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Licentie_2.png")));
        Menu_Help.add(MenuItem_Licentie);
        JMenuItem MenuItem_Over = new JMenuItem("Over TrainSound");
        MenuItem_Over.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String Info = Label_ProgrammaInfo.getText();
                    String Text = ProgramName + " \u00a9 versie " + ProgramVersion + "\nProgramma ge\u00efnstalleerd op: " + config[1] + "\nOperating systeem: " + OsName + "\nRechten \u00a9 UniekSoft " + dtf5.format(dateNow) + "\nAuteur Willy de Vaal\nWebsite https://wdevaal.nl\n";
                    if (Boolean.parseBoolean(config[3])) {
                        Text = Text + "Gebruikers licentie verleend aan: " + config[4] + "\n";
                    } else {
                        int i = (int)ChronoUnit.DAYS.between(LocalDate.now(), LocalDate.parse(config[2]));
                        Text = Text + "Uw gebruikers licentie loopt af over " + i + " dagen\n";
                        if (i <= 1) {
                            Text = Text + "Uw gebruikers licentie van 30 dagen zijn voorbij\n";
                        }
                    }
                    Label_ProgrammaInfo.setText("Over TrainSound.");
                    Main.this.msgDialog(1, "", Text);
                    Label_ProgrammaInfo.setText(Info);
                }
                catch (Exception e1) {
                    System.out.println("Error MenuItem_Over: " + String.valueOf(e1));
                }
            }
        });
        MenuItem_Over.setFont(myFont);
        MenuItem_Over.setBackground(myColor);
        MenuItem_Over.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Over.png")));
        Menu_Help.add(MenuItem_Over);
        Button_Play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Label_ProgrammaInfo.setText("Geluidsfragment afspelen.");
                    playSound = config[5] + Separator + List_Fragmenten.getSelectedValue() + ".wav";
                    File soundPath = new File(playSound);
                    if (List_Fragmenten.getSelectedValue() == "null") {
                        return;
                    }
                    if (soundPath.exists()) {
                        if (mute) {
                            currentVolume = previousVolume;
                            fc.setValue(previousVolume);
                            Button_Mute.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Mute_1.png")));
                            Button_Mute.setToolTipText("Geluid dempen");
                            mute = false;
                        }
                        int i = cliploop;
                        cliploop = 1;
                        Main.this.playClip(soundPath);
                        fc.setValue(VolumeSlider.getValue());
                        currentVolume = fc.getValue();
                        cliploop = i;
                    }
                    long clipLength1 = clipLength / 60L;
                    long clipLength2 = clipLength1 * 60L;
                    TextField_Clip.setText(" " + List_Fragmenten.getSelectedValue());
                    TextField_Length.setText(" Afspeeltijd is " + clipLength1 + " minuten en " + (clipLength -= clipLength2) + " seconden.");
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Play: " + String.valueOf(e1));
                }
            }
        });
        Button_Play.setEnabled(false);
        Button_Play.setFocusable(false);
        Button_Play.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Play.png")));
        Button_Play.setToolTipText("Geluidsfragment afspelen");
        Button_Play.setFont(myFont);
        Button_Play.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Play.setBounds(10, 530, 82, 25);
        Button_Play.setMargin(new Insets(0, 0, 0, 0));
        Button_Play.setFocusable(false);
        this.frame.getContentPane().add(Button_Play);
        Button_Stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Label_ProgrammaInfo.setText("Afspelen is gestopt.");
                    clip.stop();
                    clip.close();
                    TextField_Clip.setText(" ");
                    TextField_Length.setText(" ");
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Stop: " + String.valueOf(e1));
                }
            }
        });
        Button_Stop.setEnabled(false);
        Button_Stop.setFocusable(false);
        Button_Stop.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Stop.png")));
        Button_Stop.setToolTipText("Stop afspelen");
        Button_Stop.setFont(myFont);
        Button_Stop.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Stop.setBounds(97, 530, 82, 25);
        Button_Stop.setMargin(new Insets(0, 0, 0, 0));
        Button_Stop.setFocusable(false);
        this.frame.getContentPane().add(Button_Stop);
        Button_Select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DefaultListModel<String> DLM = new DefaultListModel<String>();
                    tempList.add(List_Fragmenten.getSelectedValue());
                    int i = 0;
                    while (i < tempList.size()) {
                        DLM.addElement(tempList.get(i));
                        List_Afspeellijst.setModel(DLM);
                        ++i;
                    }
                    playList.removeAll(playList);
                    i = 0;
                    while (i < tempList.size()) {
                        playList.add(tempList.get(i));
                        ++i;
                    }
                    TextField_Clip.setText(" ");
                    TextField_Length.setText(" ");
                    Button_Wissen.setEnabled(true);
                    Button_Start.setEnabled(true);
                    Button_Save.setEnabled(true);
                    Label_ProgrammaInfo.setText("Geluidsfragment \" " + List_Fragmenten.getSelectedValue() + ".wav \" is geselecteerd.");
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Select: " + String.valueOf(e1));
                }
            }
        });
        Button_Select.setEnabled(false);
        Button_Select.setFocusable(false);
        Button_Select.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Select.png")));
        Button_Select.setToolTipText("Selecteer geluidsfragment");
        Button_Select.setFont(myFont);
        Button_Select.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Select.setBounds(184, 530, 82, 25);
        Button_Select.setMargin(new Insets(0, 0, 0, 0));
        Button_Select.setFocusable(false);
        this.frame.getContentPane().add(Button_Select);
        Button_Wissen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    List_Afspeellijst.setListData((String[])new String[0]);
                    tempList.removeAll(tempList);
                    playList.removeAll(playList);
                    Button_Play.setEnabled(true);
                    Button_Stop.setEnabled(true);
                    Button_Select.setEnabled(true);
                    Button_Start.setEnabled(false);
                    Button_Beeindig.setEnabled(false);
                    Button_Wissen.setEnabled(false);
                    Button_Load.setEnabled(true);
                    TextField_Clip.setText(" ");
                    TextField_Length.setText(" ");
                    Label_ProgrammaInfo.setText("Selecteerd een geluidsfragment.");
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Reset: " + String.valueOf(e1));
                }
            }
        });
        Button_Wissen.setFocusable(false);
        Button_Wissen.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Reset.png")));
        Button_Wissen.setToolTipText("Reset afspeellijst");
        Button_Wissen.setFont(myFont);
        Button_Wissen.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Wissen.setBounds(276, 530, 82, 25);
        Button_Wissen.setMargin(new Insets(0, 0, 0, 0));
        Button_Wissen.setFocusable(false);
        Button_Wissen.setEnabled(false);
        this.frame.getContentPane().add(Button_Wissen);
        Button_Start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AudioInputStream appendedFiles;
                    AudioInputStream clip2;
                    AudioInputStream clip1;
                    if (playList.size() < 2) {
                        Main.this.msgDialog(2, "", "Voer minimaal twee geluidsfragmenten in. ");
                        return;
                    }
                    Button_Play.setEnabled(false);
                    Button_Stop.setEnabled(false);
                    Button_Select.setEnabled(false);
                    Button_Wissen.setEnabled(false);
                    Button_Beeindig.setEnabled(true);
                    Button_Load.setEnabled(false);
                    Button_Save.setEnabled(false);
                    Object Result = "";
                    Object wavFile1 = "";
                    Object wavFile2 = "";
                    tempList.removeAll(tempList);
                    int i = 0;
                    i = 0;
                    while (i < playList.size()) {
                        Result = (String)Result + playList.get(i) + "\n";
                        tempList.add(config[5] + playList.get(i) + ".wav");
                        ++i;
                    }
                    file = new File("Playlist.csv");
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (FileWriter writer = new FileWriter(file, false);){
                        writer.write((String)Result);
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    i = (Integer)Spinner_Pauzen.getValue();
                    if (i == 5) {
                        wavFile2 = "Sound" + Separator + "Pauzen_5.wav";
                    } else if (i == 10) {
                        wavFile2 = "Sound" + Separator + "Pauzen_10.wav";
                    } else if (i == 15) {
                        wavFile2 = "Sound" + Separator + "Pauzen_15.wav";
                    } else if (i == 20) {
                        wavFile2 = "Sound" + Separator + "Pauzen_20.wav";
                    } else if (i == 25) {
                        wavFile2 = "Sound" + Separator + "Pauzen_25.wav";
                    } else if (i == 30) {
                        wavFile2 = "Sound" + Separator + "Pauzen_30.wav";
                    } else if (i == 35) {
                        wavFile2 = "Sound" + Separator + "Pauzen_35.wav";
                    } else if (i == 40) {
                        wavFile2 = "Sound" + Separator + "Pauzen_40.wav";
                    } else if (i == 45) {
                        wavFile2 = "Sound" + Separator + "Pauzen_45.wav";
                    } else if (i == 50) {
                        wavFile2 = "Sound" + Separator + "Pauzen_50.wav";
                    } else if (i == 55) {
                        wavFile2 = "Sound" + Separator + "Pauzen_55.wav";
                    } else if (i == 60) {
                        wavFile2 = "Sound" + Separator + "Pauzen_60.wav";
                    }
                    if (chckbxGeenPauzenInvoeren.isSelected()) {
                        wavFile2 = "Sound" + Separator + "Pauzen_0.wav";
                    }
                    i = 0;
                    while (i < tempList.size()) {
                        wavFile1 = tempList.get(i).toString();
                        clip1 = AudioSystem.getAudioInputStream(new File((String)wavFile1));
                        clip2 = AudioSystem.getAudioInputStream(new File((String)wavFile2));
                        appendedFiles = new AudioInputStream(new SequenceInputStream(clip1, clip2), clip2.getFormat(), clip1.getFrameLength() + clip2.getFrameLength());
                        AudioSystem.write(appendedFiles, AudioFileFormat.Type.WAVE, new File("Playlist" + Separator + "Fragment" + i + ".wav"));
                        clip1.close();
                        clip2.close();
                        ++i;
                    }
                    wavFile1 = "Playlist" + Separator + "Fragment0.wav";
                    wavFile2 = "Playlist" + Separator + "Fragment1.wav";
                    clip1 = AudioSystem.getAudioInputStream(new File((String)wavFile1));
                    clip2 = AudioSystem.getAudioInputStream(new File((String)wavFile2));
                    appendedFiles = new AudioInputStream(new SequenceInputStream(clip1, clip2), clip2.getFormat(), clip1.getFrameLength() + clip2.getFrameLength());
                    AudioSystem.write(appendedFiles, AudioFileFormat.Type.WAVE, new File("Playlist" + Separator + "Playlist1.wav"));
                    clip1.close();
                    clip2.close();
                    i = 2;
                    while (i < tempList.size()) {
                        wavFile2 = "Playlist" + Separator + "Fragment" + i + ".wav";
                        wavFile1 = "Playlist" + Separator + "Playlist" + (i - 1) + ".wav";
                        clip1 = AudioSystem.getAudioInputStream(new File((String)wavFile1));
                        clip2 = AudioSystem.getAudioInputStream(new File((String)wavFile2));
                        appendedFiles = new AudioInputStream(new SequenceInputStream(clip1, clip2), clip2.getFormat(), clip1.getFrameLength() + clip2.getFrameLength());
                        AudioSystem.write(appendedFiles, AudioFileFormat.Type.WAVE, new File("Playlist" + Separator + "Playlist" + i + ".wav"));
                        clip1.close();
                        clip2.close();
                        ++i;
                    }
                    File f = new File("Playlist" + Separator + "Playlist" + (i - 1) + ".wav");
                    File r = new File("Playlist" + Separator + "Playlist.wav");
                    if (f.exists()) {
                        r.delete();
                        f.renameTo(r);
                    }
                    File soundPath = new File("Playlist" + Separator + "Playlist.wav");
                    Main.this.playClip(soundPath);
                    fc.setValue(VolumeSlider.getValue());
                    long clipLength1 = clipLength / 60L;
                    long clipLength2 = clipLength1 * 60L;
                    TextField_Clip.setText(" Afspeellijst afspelen");
                    TextField_Length.setText(" Afspeeltijd is " + clipLength1 + " minuten en " + (clipLength -= clipLength2) + " seconden.");
                    if (chckbxGeenPauzenInvoeren.isSelected()) {
                        if (cliploop > 0) {
                            Label_ProgrammaInfo.setText("Afspeellijst wordt " + cliploop + " keer afgespeeld (Pauzen is niet ingesteld.");
                        } else {
                            Label_ProgrammaInfo.setText("Afspeellijst wordt oneindig afgespeeld.");
                        }
                    } else if (cliploop > 0) {
                        Label_ProgrammaInfo.setText("Afspeellijst wordt " + cliploop + " keer afgespeeld (Pauzen ingesteld op " + clipPauzen + " sec.).");
                    } else {
                        Label_ProgrammaInfo.setText("Afspeellijst wordt oneindig afgespeeld.");
                    }
                    i = 0;
                    while (i < 50) {
                        file = new File("Playlist" + Separator + "Fragment" + i + ".wav");
                        if (file.exists()) {
                            file.delete();
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < 50) {
                        file = new File("Playlist" + Separator + "Playlist" + i + ".wav");
                        if (file.exists()) {
                            file.delete();
                        }
                        ++i;
                    }
                    Label_Progress.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Progress_2.gif")));
                    Button_Start.setEnabled(false);
                    MenuItem_Opslaan.setEnabled(false);
                    List_Fragmenten.setSelectedIndex(0);
                    Main.this.msgDialog(1, "", "Het afspelen is gestart \nKlik op de knop \"Be\u00ebindig\" om het proces te stoppen. ");
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Start: " + String.valueOf(e1));
                }
            }
        });
        Button_Start.setFocusable(false);
        Button_Start.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Start.png")));
        Button_Start.setToolTipText("Start afspeellijst afspelen");
        Button_Start.setFont(myFont);
        Button_Start.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Start.setBounds(365, 530, 82, 25);
        Button_Start.setMargin(new Insets(0, 0, 0, 0));
        Button_Start.setFont(myFont);
        Button_Start.setFocusable(false);
        Button_Start.setEnabled(false);
        this.frame.getContentPane().add(Button_Start);
        Button_Beeindig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    clip.stop();
                    clip.close();
                    System.gc();
                    Label_Progress.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Progress_1.png")));
                    Button_Start.setEnabled(true);
                    Button_Wissen.setEnabled(true);
                    MenuItem_Opslaan.setEnabled(true);
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Beeindig: " + String.valueOf(e1));
                }
            }
        });
        Button_Beeindig.setToolTipText("Be\u00ebindig het afspelen");
        Button_Beeindig.setMargin(new Insets(0, 0, 0, 0));
        Button_Beeindig.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Stop.png")));
        Button_Beeindig.setFont(myFont);
        Button_Beeindig.setFocusable(false);
        Button_Beeindig.setEnabled(false);
        Button_Beeindig.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Beeindig.setBounds(454, 530, 82, 25);
        this.frame.getContentPane().add(Button_Beeindig);
        Button_Load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block14: {
                    try {
                        file = new File("Playlist.csv");
                        if (file.exists()) {
                            String Result = "";
                            DefaultListModel<String> DLM2 = new DefaultListModel<String>();
                            Throwable throwable = null;
                            Object var5_7 = null;
                            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                                while ((Result = br.readLine()) != null) {
                                    DLM2.addElement(Result);
                                    List_Afspeellijst.setModel(DLM2);
                                    playList.add(Result.toString());
                                }
                                br.close();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            Button_Play.setEnabled(false);
                            Button_Stop.setEnabled(false);
                            Button_Select.setEnabled(false);
                            Button_Start.setEnabled(true);
                            Button_Wissen.setEnabled(true);
                            Button_Load.setEnabled(false);
                            Label_ProgrammaInfo.setText("Klik Start om af te spelen.");
                            break block14;
                        }
                        Main.this.msgDialog(1, "", "Er is nog geen afspeellijst opgeslagen. ");
                    }
                    catch (Exception e1) {
                        System.out.println("Error Button_Load: " + String.valueOf(e1));
                    }
                }
            }
        });
        Button_Load.setFocusable(false);
        Button_Load.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Open.png")));
        Button_Load.setToolTipText("Open laatste afspeellijst");
        Button_Load.setFont(myFont);
        Button_Load.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Load.setBounds(607, 530, 82, 25);
        Button_Load.setMargin(new Insets(0, 0, 0, 0));
        Button_Load.setFocusable(false);
        this.frame.getContentPane().add(Button_Load);
        Button_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object Result = "";
                    int i = 0;
                    i = 0;
                    while (i < playList.size()) {
                        Result = (String)Result + playList.get(i) + "\n";
                        ++i;
                    }
                    file = new File("Playlist.csv");
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (FileWriter writer = new FileWriter(file, false);){
                        writer.write((String)Result);
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    Label_ProgrammaInfo.setText("Afspeellijst is opgeslagen.");
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Save: " + String.valueOf(e1));
                }
            }
        });
        Button_Save.setToolTipText("Afspeellijst bewaren");
        Button_Save.setMargin(new Insets(0, 0, 0, 0));
        Button_Save.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Save.png")));
        Button_Save.setFont(new Font("SansSerif", 0, 12));
        Button_Save.setFocusable(false);
        Button_Save.setEnabled(false);
        Button_Save.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Save.setBounds(693, 530, 82, 25);
        this.frame.getContentPane().add(Button_Save);
        Button_Mute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!mute) {
                        previousVolume = currentVolume;
                        currentVolume = -80.0f;
                        fc.setValue(currentVolume);
                        Button_Mute.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Mute_2.png")));
                        Button_Mute.setToolTipText("Geluid niet dempen");
                        mute = true;
                    } else {
                        currentVolume = previousVolume;
                        fc.setValue(previousVolume);
                        Button_Mute.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Mute_1.png")));
                        Button_Mute.setToolTipText("Geluid dempen");
                        mute = false;
                    }
                }
                catch (Exception e1) {
                    System.out.println("Error Button_Mute: " + String.valueOf(e1));
                }
            }
        });
        Button_Mute.setFocusable(false);
        Button_Mute.setToolTipText("Geluid dempen");
        Button_Mute.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Button_Mute_1.png")));
        Button_Mute.setBorder(new BevelBorder(0, null, null, null, null));
        Button_Mute.setBounds(800, 403, 26, 26);
        this.frame.getContentPane().add(Button_Mute);
        JScrollPane ScrollPane_Fragmenten = new JScrollPane();
        ScrollPane_Fragmenten.setBounds(10, 35, 258, 485);
        this.frame.getContentPane().add(ScrollPane_Fragmenten);
        List_Fragmenten.setFont(myFont);
        List_Fragmenten.setBorder(new BevelBorder(1, null, null, null, null));
        List_Fragmenten.setToolTipText("Selecteer een geluidsfragment");
        ScrollPane_Fragmenten.setViewportView(List_Fragmenten);
        JScrollPane ScrollPane_Afspeellijst = new JScrollPane();
        ScrollPane_Afspeellijst.setBounds(278, 35, 258, 485);
        this.frame.getContentPane().add(ScrollPane_Afspeellijst);
        List_Afspeellijst.setFont(myFont);
        List_Afspeellijst.setBorder(new BevelBorder(1, null, null, null, null));
        List_Afspeellijst.setToolTipText("Geselecteerde geluidsfragmenten");
        ScrollPane_Afspeellijst.setViewportView(List_Afspeellijst);
        VolumeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    fc.setValue(VolumeSlider.getValue());
                    currentVolume = fc.getValue();
                }
                catch (Exception e1) {
                    System.out.println("Error VolumeSlider: " + String.valueOf(e1));
                }
            }
        });
        VolumeSlider.setToolTipText("Stel volume in");
        VolumeSlider.setFont(myFont);
        VolumeSlider.setBorder(new BevelBorder(1, null, null, null, null));
        VolumeSlider.setBounds(592, 403, 200, 26);
        this.frame.getContentPane().add(VolumeSlider);
        chckbxGeenPauzenInvoeren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (chckbxGeenPauzenInvoeren.isSelected()) {
                        chckbxGeenPauzenInvoeren.setSelected(true);
                        Spinner_Pauzen.setEnabled(false);
                    } else {
                        chckbxGeenPauzenInvoeren.setSelected(false);
                        Spinner_Pauzen.setEnabled(true);
                    }
                }
                catch (Exception e1) {
                    System.out.println("Error CheckBox_Pauzen: " + String.valueOf(e1));
                }
            }
        });
        chckbxGeenPauzenInvoeren.setFont(myFont);
        chckbxGeenPauzenInvoeren.setBounds(588, 277, 168, 23);
        this.frame.getContentPane().add(chckbxGeenPauzenInvoeren);
        Spinner_Pauzen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    Main.config[7] = Integer.toString((Integer)Spinner_Pauzen.getValue());
                    clipPauzen = Integer.parseInt(config[7]);
                    if (Integer.parseInt(config[7]) < 5) {
                        clipPauzen = 5;
                    } else if (Integer.parseInt(config[7]) > 5 && clipPauzen <= 10) {
                        clipPauzen = 10;
                    } else if (Integer.parseInt(config[7]) > 10 && clipPauzen <= 15) {
                        clipPauzen = 15;
                    } else if (Integer.parseInt(config[7]) > 15 && clipPauzen <= 20) {
                        clipPauzen = 20;
                    } else if (Integer.parseInt(config[7]) > 20 && clipPauzen <= 25) {
                        clipPauzen = 25;
                    } else if (Integer.parseInt(config[7]) > 25 && clipPauzen <= 30) {
                        clipPauzen = 30;
                    } else if (Integer.parseInt(config[7]) > 30 && clipPauzen <= 35) {
                        clipPauzen = 35;
                    } else if (Integer.parseInt(config[7]) > 35 && clipPauzen <= 40) {
                        clipPauzen = 40;
                    } else if (Integer.parseInt(config[7]) > 40 && clipPauzen <= 45) {
                        clipPauzen = 45;
                    } else if (Integer.parseInt(config[7]) > 45 && clipPauzen <= 50) {
                        clipPauzen = 50;
                    } else if (Integer.parseInt(config[7]) > 50 && clipPauzen <= 55) {
                        clipPauzen = 55;
                    } else if (Integer.parseInt(config[7]) > 55 && clipPauzen <= 60) {
                        clipPauzen = 60;
                    }
                    Spinner_Pauzen.setValue(clipPauzen);
                    Main.this.configFile(1);
                }
                catch (Exception e1) {
                    System.out.println("Error Spinner_Pauzen: " + String.valueOf(e1));
                }
            }
        });
        Spinner_Pauzen.setFocusable(false);
        Spinner_Pauzen.setBorder(new BevelBorder(1, null, null, null, null));
        Spinner_Pauzen.setModel(new SpinnerNumberModel(5, 5, 60, 5));
        Spinner_Pauzen.setToolTipText("Aantal seconden pauzen tussen de geluidsfragmenten");
        Spinner_Pauzen.setFont(myFont);
        Spinner_Pauzen.setBounds(592, 307, 52, 25);
        this.frame.getContentPane().add(Spinner_Pauzen);
        Spinner_Herhalen.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    Main.config[6] = Integer.toString((Integer)Spinner_Herhalen.getValue());
                    cliploop = Integer.parseInt(config[6]);
                    Main.this.configFile(1);
                }
                catch (Exception e1) {
                    System.out.println("Error Spinner_Herhalen: " + String.valueOf(e1));
                }
            }
        });
        Spinner_Herhalen.setFocusable(false);
        Spinner_Herhalen.setFocusable(false);
        Spinner_Herhalen.setToolTipText("Aantal keren herhalen (0 is eindeloos)");
        Spinner_Herhalen.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(0), null, (Number)1));
        Spinner_Herhalen.setBorder(new BevelBorder(1, null, null, null, null));
        Spinner_Herhalen.setFont(myFont);
        Spinner_Herhalen.setBounds(592, 343, 52, 25);
        this.frame.getContentPane().add(Spinner_Herhalen);
        Label_ProgrammaInfo.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Label_ProgramInfo.png")));
        Label_ProgrammaInfo.setFont(myFont);
        Label_ProgrammaInfo.setBounds(10, 568, 689, 14);
        Label_ProgrammaInfo.setForeground(new Color(0, 0, 255));
        this.frame.getContentPane().add(Label_ProgrammaInfo);
        JLabel Label_Datum = new JLabel("Datum");
        Label_Datum.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Label_Datum.png")));
        Label_Datum.setHorizontalAlignment(4);
        Label_Datum.setForeground(new Color(0, 0, 255));
        Label_Datum.setFont(myFont);
        Label_Datum.setBounds(713, 568, 161, 14);
        Label_Datum.setText("Datum " + dtf2.format(dateNow));
        this.frame.getContentPane().add(Label_Datum);
        Label Label__Fragmenten = new Label("Geluidsfragment.");
        Label__Fragmenten.setAlignment(1);
        Label__Fragmenten.setFont(myFont);
        Label__Fragmenten.setBounds(10, 10, 256, 22);
        this.frame.getContentPane().add(Label__Fragmenten);
        Label Label__Afspeellijst = new Label("Afspeellijst.");
        Label__Afspeellijst.setFont(myFont);
        Label__Afspeellijst.setAlignment(1);
        Label__Afspeellijst.setBounds(280, 10, 256, 22);
        this.frame.getContentPane().add(Label__Afspeellijst);
        Label Label_Pauzen = new Label("Pauzen in seconden.");
        Label_Pauzen.setFont(myFont);
        Label_Pauzen.setBounds(650, 310, 176, 22);
        this.frame.getContentPane().add(Label_Pauzen);
        Label Label_Herhalen = new Label("Keren herhalen (0 is oneindig).");
        Label_Herhalen.setFont(myFont);
        Label_Herhalen.setBounds(650, 343, 176, 22);
        this.frame.getContentPane().add(Label_Herhalen);
        Label Label_Volume = new Label("Volume regeling.");
        Label_Volume.setAlignment(1);
        Label_Volume.setFont(myFont);
        Label_Volume.setBounds(592, 379, 200, 22);
        this.frame.getContentPane().add(Label_Volume);
        Label Label_Mute = new Label("Mute.");
        Label_Mute.setFont(myFont);
        Label_Mute.setBounds(800, 379, 30, 22);
        this.frame.getContentPane().add(Label_Mute);
        Label Label__Clip = new Label("Geluidsfragment.");
        Label__Clip.setFont(myFont);
        Label__Clip.setBounds(542, 35, 176, 22);
        this.frame.getContentPane().add(Label__Clip);
        Label Label_Tijdsduur = new Label("Tijdsduur.");
        Label_Tijdsduur.setFont(myFont);
        Label_Tijdsduur.setBounds(545, 103, 176, 22);
        this.frame.getContentPane().add(Label_Tijdsduur);
        Label Label__Afspeellijst_Buttons = new Label("Afspeellijst.");
        Label__Afspeellijst_Buttons.setFont(myFont);
        Label__Afspeellijst_Buttons.setAlignment(1);
        Label__Afspeellijst_Buttons.setBounds(607, 502, 168, 22);
        this.frame.getContentPane().add(Label__Afspeellijst_Buttons);
        Label_Progress.setToolTipText("Klik \"Be\u00ebindig\" om te stoppen");
        Label_Progress.setBorder(new BevelBorder(0, null, null, null, null));
        Label_Progress.setToolTipText("Klik \"Be\u00ebindig\" om te stoppen");
        Label_Progress.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/Progress_1.png")));
        Label_Progress.setBounds(677, 196, 55, 55);
        this.frame.getContentPane().add(Label_Progress);
        TextField_Clip = new JTextField();
        TextField_Clip.setBorder(new BevelBorder(1, null, null, null, null));
        TextField_Clip.setFont(myFont);
        TextField_Clip.setBounds(546, 60, 328, 25);
        this.frame.getContentPane().add(TextField_Clip);
        TextField_Length = new JTextField();
        TextField_Length.setBorder(new BevelBorder(1, null, null, null, null));
        TextField_Length.setFont(myFont);
        TextField_Length.setBounds(546, 124, 328, 25);
        this.frame.getContentPane().add(TextField_Length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configFile(int n) {
        file = new File("Config.csv");
        switch (n) {
            case 1: {
                try {
                    Object Result = "";
                    int i = 0;
                    i = 0;
                    while (i < config.length) {
                        Result = (String)Result + config[i] + "\n";
                        ++i;
                    }
                    Throwable throwable = null;
                    Object var5_12 = null;
                    try {
                        FileWriter writer = new FileWriter(file, false);
                        try {
                            writer.write((String)Result);
                            writer.close();
                            if (writer == null) return;
                        }
                        catch (Throwable throwable2) {
                            if (writer == null) throw throwable2;
                            writer.close();
                            throw throwable2;
                        }
                        writer.close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error void configFile 1: " + String.valueOf(e));
                    this.msgDialog(2, "Waarschuwing", "Het Config bestand is zodanig beschadigd dat het programma nu wordt afgesloten.\nNeem contact op het de auteur om de fout op te lossen. ");
                    System.exit(0);
                }
                return;
            }
            case 2: {
                try {
                    String Result = "";
                    int i = 0;
                    Throwable throwable = null;
                    Object var5_14 = null;
                    try (BufferedReader br = new BufferedReader(new FileReader(file));){
                        while ((Result = br.readLine()) != null) {
                            Main.config[i] = Result;
                            ++i;
                        }
                        br.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        } else {
                            if (throwable == throwable4) throw throwable;
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                    if (Boolean.parseBoolean(config[3])) {
                        MenuItem_Licentie.setIcon(new ImageIcon(Main.class.getResource("/TrainSound/Images/MenuItem_Licentie_1.png")));
                    }
                    Spinner_Herhalen.setValue(Integer.parseInt(config[6]));
                    Spinner_Pauzen.setValue(Integer.parseInt(config[7]));
                    cliploop = Integer.parseInt(config[6]);
                    clipPauzen = Integer.parseInt(config[7]);
                    return;
                }
                catch (Exception e) {
                    System.out.println("Error void configFile 2: " + String.valueOf(e));
                    this.msgDialog(2, "", "Het Config bestand is zodanig beschadigd dat het programma nu wordt afgesloten.\nNeem contact op het de auteur om de fout op te lossen. ");
                    System.exit(0);
                }
            }
        }
    }

    public void Licentie() {
        block19: {
            try {
                int i = (int)ChronoUnit.DAYS.between(LocalDate.now(), LocalDate.parse(config[2]));
                file = new File("UniekSoft.key");
                if (file.exists()) {
                    Object Result = "";
                    i = 0;
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (BufferedReader br = new BufferedReader(new FileReader(file));){
                        while ((Result = br.readLine()) != null) {
                            Main.licentie[i] = Result;
                            ++i;
                        }
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    Result = "UniekSoft" + licentie[0] + licentie[1] + licentie[2];
                    i = 1;
                    Object b = "";
                    i = 0;
                    while (i < ((String)Result).length()) {
                        char c = ((String)Result).toString().charAt(i);
                        b = (String)b + String.valueOf((int)c);
                        ++i;
                    }
                    if (((String)b).contains(licentie[3])) {
                        Main.config[3] = "true";
                        Main.config[4] = licentie[0];
                        this.configFile(1);
                        this.configFile(2);
                        Label_ProgrammaInfo.setText("Gebruikers licentie verleend aan: " + config[4]);
                    } else {
                        Main.config[3] = "false";
                        Main.config[4] = "false";
                        this.configFile(1);
                        this.configFile(2);
                        this.msgDialog(2, "", "Uw Licentie Sleutel is niet voor dit programma.\nVerwijder nu eerst de ongeldige Licentie Sleutel.\nNeem contact op met de auteur of vraag nu een nieuwe Licentie Sleutel aan.\nHet programma wordt nu afgesloten. ");
                        System.exit(0);
                    }
                    break block19;
                }
                if (i > 0) {
                    Label_ProgrammaInfo.setText("Uw gebruikers Licentie loopt af over " + i + " dagen.");
                } else {
                    Button_Play.setEnabled(false);
                    Button_Stop.setEnabled(false);
                    Button_Select.setEnabled(false);
                    Button_Wissen.setEnabled(false);
                    Button_Start.setEnabled(false);
                    Button_Load.setEnabled(false);
                    Button_Mute.setEnabled(false);
                    Label_ProgrammaInfo.setText("Uw gebruikers Licentie is verlopen!");
                    this.msgDialog(2, "", "Uw gebruikers Licentie is verlopen! \nVraag eerst een Licentie Sleutel aan. ");
                }
            }
            catch (Exception e) {
                System.out.println("Error void Licentie: " + String.valueOf(e));
            }
        }
    }

    public void msgDialog(int n, String Info2, String Text) {
        try {
            Object[] options = new String[3];
            switch (n) {
                case 1: {
                    JOptionPane.showMessageDialog(null, Text, Info2, 1, null);
                    break;
                }
                case 2: {
                    JOptionPane.showMessageDialog(null, Text, Info2, 2, null);
                    break;
                }
                case 3: {
                    options = new String[]{"Ja", "Nee"};
                    int i = JOptionPane.showOptionDialog(null, Text, Info2, 0, 1, null, options, null);
                    if (i == 0) {
                        msgAnser = true;
                        break;
                    }
                    msgAnser = false;
                    break;
                }
                case 4: {
                    options = new String[]{"Ja", "Nee"};
                    int i = JOptionPane.showOptionDialog(null, Text, Info2, 0, 2, null, options, null);
                    if (i == 0) {
                        msgAnser = true;
                        break;
                    }
                    msgAnser = false;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error void msgDialog: " + String.valueOf(e));
        }
    }

    public void listBox() {
        try {
            if (config[5].contains("null")) {
                this.msgDialog(2, "", "De Map met uw geluidsfragmenten zijn nog niet gedevieerd! \nKlik menu optie \"Programma\" > \"Locatie Geluidsfragmenten\". \nEn kies uw map met geluidsfragmenten. ");
                return;
            }
            File dir = new File(config[5] + Separator);
            File[] contentsOfDirectory = dir.listFiles();
            Path dirPath = Paths.get(config[5] + Separator, new String[0]);
            boolean isEmptyDirectory = Files.list(dirPath).findAny().isPresent();
            if (isEmptyDirectory) {
                File[] fileArray = contentsOfDirectory;
                int n = contentsOfDirectory.length;
                int n2 = 0;
                while (n2 < n) {
                    File object = fileArray[n2];
                    String str = object.getName();
                    if (str.contains(".wav")) {
                        loadSound.add(str.replace(".wav", ""));
                    }
                    ++n2;
                }
            }
            loadSound.sort(Comparator.naturalOrder());
            DefaultListModel<String> DLM = new DefaultListModel<String>();
            int i = 0;
            while (i < loadSound.size()) {
                DLM.addElement(loadSound.get(i));
                List_Fragmenten.setModel(DLM);
                ++i;
            }
            List_Fragmenten.setSelectedIndex(0);
            loadSound.removeAll(loadSound);
            Button_Play.setEnabled(true);
            Button_Stop.setEnabled(true);
            Button_Select.setEnabled(true);
        }
        catch (Exception e) {
            System.out.println("Error void listBox: " + String.valueOf(e));
        }
    }

    public void playClip(File soundPath) {
        try {
            AudioInputStream sound = AudioSystem.getAudioInputStream(soundPath);
            clip = AudioSystem.getClip();
            clip.open(sound);
            fc = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            clipLength = clip.getMicrosecondLength() / 1000000L;
            if (cliploop <= 0) {
                clip.loop(-1);
            } else {
                clip.loop(cliploop - 1);
            }
            clip.start();
        }
        catch (Exception e) {
            System.out.println("Error void playClip: " + String.valueOf(e));
        }
    }
}

